function x = convertP(p)

% x = convertX(p)
%
% Input Variables
%   p - structure format for x
%
% Output Variables
%   x - parameters for the ecgGen that are to be estimated
%
% Description
%   Converts format of paramters

% Created
%   4/22/2006, Richard J. Povinelli, Marquette University
%
% Modified
%   Mohamed A Mneimneh, Marquette University

% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
%rename the x values
[region featuresPerModel] = getRegions();
x = zeros(length(region) * featuresPerModel,1);
for i = 1:length(region)
    %sigmoid parameters, inflection points start at 1, slopes at 9
    index = (i-1) * 2 + 1; %2 inflection points & 2 slopes per region
    temp = p.(region{i}).sig;
    x(index+2*length(region)) = temp(1);
    x(index) = temp(2);
    x(index+2*length(region)+1) = temp(3);
    x(index+1) = temp(4);

    %magnitude of the regions signal
    index = (i-1) + 4*length(region)+1; %magnitudes start at x(17)
    x(index) = p.(region{i}).mag;

    %   %delays start at 21, positive than negative
    index = (i-1) * 4 + 5*length(region)+1; %2 inflection points & 2 slopes per region
    x(index) = p.(region{i}).posDelta1;
    x(index+1) = p.(region{i}).posDelta2;
    x(index + 2) = p.(region{i}).negDelta1;
    x(index + 3) = p.(region{i}).negDelta2;
end %for